{
  description = "A dummy docspell addon";

  inputs = {
    utils.url = "github:numtide/flake-utils";

    dsc.url = "github:docspell/dsc";
    dsc.inputs.nixpkgs.follows = "nixpkgs";

    # Nixpkgs / NixOS version to use.
    nixpkgs.url = "nixpkgs/nixos-21.11";
  };

  outputs = { self, nixpkgs, dsc, utils }:
    utils.lib.eachDefaultSystem (system:
      let
        pkgs = import nixpkgs {
          inherit system;
          overlays = [
            (self: super:
              { dsc = dsc.defaultPackage.${system};
              }
            )
          ];
        };
        name = "docspell-dummy-addon";
      in rec {
        packages.${name} = pkgs.callPackage ./nix/addon.nix {
          inherit name;
        };

        defaultPackage = packages.${name};

        apps.${name} = utils.lib.mkApp {
          inherit name;
          drv = packages.${name};
        };
        defaultApp = apps.${name};

        devShell = pkgs.mkShell {
          inputsFrom = builtins.attrValues self.packages.${system};
          buildInputs =
            [ pkgs.jq
              pkgs.coreutils
              pkgs.dsc
            ];

          ADDON_DIR = self;
          TMPDIR = "/tmp";
        };
      }
    );
}
